USE [DownloadStatistics]
GO

/****** Object:  StoredProcedure [dbo].[UpdateProjectDownloadsLastThirtyDays]    Script Date: 9/17/2014 12:01:19 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO




-- =============================================
-- Author:		<James Davis>
-- Create date: <2013/06/10>
-- Description:	<This just updates the project DownloadsLastThirtyDays, so it can be updated more than once a day, but not less than every 30 mins>
-- =============================================
ALTER PROCEDURE [dbo].[UpdateProjectDownloadsLastThirtyDays] 

AS
DECLARE @currDate DATE
BEGIN
	SET NOCOUNT ON;
	
	SELECT @currDate = CONVERT(date, GETUTCDATE());

	WITH ThirtyDayCount(ProjectID, DownloadsLastThirtyDays) AS
	(
		SELECT F.ProjectID, COUNT(1) AS DownloadsLastThirtyDays
		FROM [dbo].Record AS DLE with (nolock)
		LEFT JOIN [dbo].[File] AS F ON DLE.FileID = F.ID
		WHERE DLE.[Date] >= DATEADD(DAY, -30, CONVERT(date, GETUTCDATE())) AND F.ProjectID IS NOT NULL
		GROUP BY F.ProjectID
		UNION
		SELECT F.ProjectID, 0
		FROM [dbo].[File] F
		WHERE F.ProjectID NOT IN (SELECT F.ProjectID
				FROM [dbo].Record AS DLE 
				LEFT JOIN [dbo].[File] AS F ON DLE.FileID = F.ID
				WHERE DLE.[Date] >= DATEADD(DAY, -30, CONVERT(date, GETUTCDATE())) AND F.ProjectID IS NOT NULL)
	)
	MERGE [dbo].[Project] AS TARGET
	USING ThirtyDayCount AS SOURCE
	ON (TARGET.ID = SOURCE.ProjectID)
	WHEN MATCHED and TARGET.DownloadsLastThirtyDays != SOURCE.DownloadsLastThirtyDays THEN
		UPDATE SET TARGET.DownloadsLastThirtyDays = SOURCE.DownloadsLastThirtyDays,
		TARGET.DateModified = GETUTCDATE();
	
END



GO

